#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

import sys

from javax.swing.event import HyperlinkListener
from javax.swing.event import HyperlinkEvent

from javax.swing import JOptionPane

from core.dict import get_definitions
from gui.utility import display_html
   
class MyHyperlinkListener(HyperlinkListener):
    def __init__(self,main_class):
        self.main_class = main_class
    
    def __do_add_category(self,word_index):
        word = self.main_class.db.words[word_index]
        category = ""
        while not category:
            category = JOptionPane.showInputDialog(
                self.main_class.main_frame,
                "Please enter category name.",
                "Add Category",
                JOptionPane.QUESTION_MESSAGE
            )
            if category == None:
                break
            category = category.strip().lower()
        
        if category:
            if self.main_class.add_category_to_word(word_index,category):
                msg = "<html><body>"
                msg += "Category <u>%s</u> added to <u>%s</u>." % (category,word.name)
                msg += "</body></html>"
                JOptionPane.showMessageDialog(self.main_class.main_frame,msg,"Category added",JOptionPane.INFORMATION_MESSAGE)
            else:
                msg = "<html><body>"
                msg += "Category <u>%s</u> already exists in <u>%s</u>." % (category,word.name)
                msg += "</body></html>"
                JOptionPane.showMessageDialog(self.main_class.main_frame,msg,"Category already exists",JOptionPane.INFORMATION_MESSAGE)
    
    def __do_delete_category(self,word_index,category):
        word = self.main_class.db.words[word_index]
        html = "<html><body>"
        html += "Are you sure you want to delete<br/>the category <u>%s</u> from <u>%s</u> ?" % (category,word.name)
        html += "</body></html>"
        confirm = JOptionPane.showConfirmDialog(self.main_class.main_frame,html,"Please Confirm",JOptionPane.YES_OPTION,JOptionPane.QUESTION_MESSAGE)
        if confirm == JOptionPane.OK_OPTION:
            if self.main_class.delete_category_from_word(word_index,category):
                msg = "<html><body>"
                msg += "Category <u>%s</u> deleted from <u>%s</u>." % (category,word.name)
                msg += "</body></html>"
                JOptionPane.showMessageDialog(self.main_class.main_frame,msg,"Category deleted",JOptionPane.INFORMATION_MESSAGE)
            else:
                msg = "<html><body>"
                msg += "Category <u>%s</u> does not exist in <u>%s</u>." % (category,word.name)
                msg += "</body></html>"
                JOptionPane.showMessageDialog(self.main_class.main_frame,msg,"Invalid category",JOptionPane.INFORMATION_MESSAGE)

    def hyperlinkUpdate(self,e):
        if e.getEventType() == HyperlinkEvent.EventType.ACTIVATED:
            if e.getDescription() == "pronunciation_guide":
                html_file = open("files/pronunciation_guide.html",'r')
                html = html_file.read()
                html_file.close()
                
                width = self.main_class.configurator.get_int("pronunciation_guide_frame.width")
                height = self.main_class.configurator.get_int("pronunciation_guide_frame.height")
                if width and height: display_html(html,"Pronunciation Guide",width,height)
                else: display_html(html,"Pronunciation Guide",400,400)

            elif e.getDescription().startswith("add_category_"):
                word_index = int(e.getDescription().split('_')[-1])
                self.__do_add_category(word_index)
            elif e.getDescription().startswith("delete_category_"):
                splits = e.getDescription().split('_')
                word_index = int(splits[-1])
                category = splits[-2]
                self.__do_delete_category(word_index,category)
            else:
                html = "<html><body><center><h1>Querying dict.org.<br>Please Wait...</h1></center></body></html>"
                
                width = self.main_class.configurator.get_int("dict_frame.width")
                height = self.main_class.configurator.get_int("dict_frame.height")
                if width and height: html_frame = display_html(html, e.getDescription(), width,height)
                else: html_frame = display_html(html, e.getDescription(), 400,400)
                
                html_frame.html_pane.addHyperlinkListener(self)

                html = "<html><body>"
                defns = get_definitions(e.getDescription()) 
                html += "<b>%d</b> definition(s) found" % len(defns)
                html += "<pre>"
                for x in defns: html += x + "<br/>"
                html += "</pre>"
                html += "</body></html>"
                html_frame.set_html(html)
