#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from java.awt.event import MouseListener 
from java.awt.event import MouseEvent 

class MouseListenerDictionary(MouseListener):
    def __init__(self,main_class):
        self.main_class = main_class

    def mouseEntered(self,e):
        pass

    def mouseClicked(self,e):
        source = e.getSource()
        if source.equals(self.main_class.dframe.cmd_search):
            text = self.main_class.dframe.txt_search.getText().lower()
            self.main_class.dframe.list_box.setSelectedValue(text,True)
            word_index = self.main_class.db.get_word_index(text)
            if word_index != -1:
                html = self.main_class.get_word_html(word_index)
                self.main_class.dframe.result_box.setText(html)
                self.main_class.dframe.result_box.setCaretPosition(0)
            else:
                self.main_class.dframe.result_box.setText("Word not found")
        elif e.getClickCount() >= 1:
                text = self.main_class.dframe.list_box.getSelectedValue()
                self.main_class.dframe.txt_search.setText(text)
                word_index = self.main_class.db.get_word_index(text)
                if word_index != -1:
                    html = self.main_class.get_word_html(word_index)
                    self.main_class.dframe.result_box.setText(html)
                    self.main_class.dframe.result_box.setCaretPosition(0)
                else:
                    self.main_class.dframe.result_box.setText("Word not found")
    
    def mouseExited(self,e):
        pass

    def mousePressed(self,e):
        pass

    def mouseReleased(self,e):
        pass
