#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

import sys

from java.awt.event import ActionListener

from javax.swing import JOptionPane

from gui.utility import display_html

from listeners.ComponentListenerPronunciation import ComponentListenerPronunciation
from listeners.ComponentListenerStatistics import ComponentListenerStatistics
from listeners.ComponentListenerHelp import ComponentListenerHelp

class MenuListenerMain(ActionListener):
    def __init__(self,main_class,index_names):
        self.main_class = main_class
        self.index_names = index_names
    
    def add_index_name(self,name):
        self.index_names.append(name)

    def actionPerformed(self,e):
        source = e.getSource()
        if source.equals(self.main_class.main_frame.menu_bar.file_menu_exit):
            msg = "<html><body>"
            msg += "This is what the program does when you click the X button at the top right corner.<br>"
            msg += "It will save your changes and exit!<br><br> The program will now save your changes and exit. Click Ok to continue.</body></html>"
            confirm = JOptionPane.showConfirmDialog(self.main_class.main_frame,msg,"Plase Confirm",JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE)
            if confirm == JOptionPane.OK_OPTION:
                print "Saving Changes..."
                if not self.main_class.save():
                    JOptionPane.showMessageDialog(self.main_class.main_frame,"An error occured saving settings","Error",JOptionPane.INFORMATION_MESSAGE)
                sys.exit(0)
        elif source.equals(self.main_class.main_frame.menu_bar.file_menu_exit_without_save):
            confirm = JOptionPane.showConfirmDialog(self.main_class.main_frame,"All changes will be lost. Are you sure?","Please Confirm",JOptionPane.YES_OPTION,JOptionPane.QUESTION_MESSAGE)
            if confirm == JOptionPane.OK_OPTION:
                sys.exit(0)
        elif source.equals(self.main_class.main_frame.menu_bar.file_menu_reset_number_of_times_tested):
            msg = "<html><body>"
            msg += "All words' <u>number of times tested</u> will be set to zero.<br/><br/>"
            msg += "This action requires exiting the program.<br/><br/>Are you sure?"
            confirm = JOptionPane.showConfirmDialog(self.main_class.main_frame,msg,"Please Confirm",JOptionPane.YES_OPTION,JOptionPane.QUESTION_MESSAGE)
            if confirm == JOptionPane.OK_OPTION:
                self.main_class.db.reset_number_of_times_tested()
                print "Saving Changes..."
                if self.main_class.save():
                    JOptionPane.showMessageDialog(
                        self.main_class.main_frame,
                        "<html><body><u>Number of times tested</u> has been reset.<br/><br/>The program will now exit.</body></html>",
                        "Success",
                        JOptionPane.INFORMATION_MESSAGE
                    )
                    sys.exit(0)
                else:
                    JOptionPane.showMessageDialog(self.main_class.main_frame,"An error occured saving settings","Error",JOptionPane.INFORMATION_MESSAGE)
        elif source.equals(self.main_class.main_frame.menu_bar.file_menu_reset_mastered_words):
            msg = "<html><body>"
            msg += "All mastered words will be reset.<br/><br/>"
            msg += "This action requires exiting the program.<br/><br/>Are you sure?"
            confirm = JOptionPane.showConfirmDialog(self.main_class.main_frame,msg,"Please Confirm",JOptionPane.YES_OPTION,JOptionPane.QUESTION_MESSAGE)
            if confirm == JOptionPane.OK_OPTION:
                self.main_class.db.reset_mastered_words()
                print "Saving Changes..."
                if self.main_class.save():
                    JOptionPane.showMessageDialog(
                        self.main_class.main_frame,
                        "<html><body>All mastered words have been reset.<br/><br/>The program will now exit.</body></html>",
                        "Success",
                        JOptionPane.INFORMATION_MESSAGE
                    )
                    sys.exit(0)
                else:
                    JOptionPane.showMessageDialog(self.main_class.main_frame,"An error occured saving settings","Error",JOptionPane.INFORMATION_MESSAGE)
        elif source.equals(self.main_class.main_frame.menu_bar.tools_menu_view_statistics):
            html = self.main_class.get_statistics_html()
            
            width = self.main_class.configurator.get_int("statistics_frame.width")
            height = self.main_class.configurator.get_int("statistics_frame.height")
            if width and height: html_frame = display_html(html,"Statistics",width,height)
            else: html_frame = display_html(html,"Statistics",400,400)
            html_frame.addComponentListener(ComponentListenerStatistics(self.main_class))

        elif source.equals(self.main_class.main_frame.menu_bar.tools_menu_pronunciation_guide):
            html_file = open("files/pronunciation_guide.html",'r')
            html = html_file.read()
            html_file.close()
            
            width = self.main_class.configurator.get_int("pronunciation_guide_frame.width")
            height = self.main_class.configurator.get_int("pronunciation_guide_frame.height")
            if width and height: html_frame = display_html(html,"Pronunciation Guide",width,height)
            else: html_frame = display_html(html,"Pronunciation Guide",400,400)
            html_frame.addComponentListener(ComponentListenerPronunciation(self.main_class))

        elif source.equals(self.main_class.main_frame.menu_bar.tools_menu_dictionary):
            self.main_class.open_dictionary()
        
        elif source.equals(self.main_class.main_frame.menu_bar.games_menu_hangman):
            self.main_class.open_hangman()
        
        elif source.equals(self.main_class.main_frame.menu_bar.help_menu_help):
            html_file = open("files/help.html",'r')
            html = html_file.read()
            html_file.close()
            
            width = self.main_class.configurator.get_int("help_frame.width")
            height = self.main_class.configurator.get_int("help_frame.height")
            if width and height: html_frame = display_html(html,"Help",width,height)
            else: html_frame = display_html(html,"Help",400,400)
            html_frame.addComponentListener(ComponentListenerHelp(self.main_class))
        
        elif source.equals(self.main_class.main_frame.menu_bar.help_menu_about):
            html_file = open("files/about.html",'r')
            html = html_file.read()
            html_file.close()
            width = self.main_class.configurator.get_int("help_frame.width")
            height = self.main_class.configurator.get_int("help_frame.height")
            if width and height: html_frame = display_html(html,"About",width,height)
            else: html_frame = display_html(html,"About",400,400)
            html_frame.addComponentListener(ComponentListenerHelp(self.main_class))
        
        elif source.getText() in self.index_names:
            self.main_class.set_active_index_name(source.getText())
