#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from java.awt.event import KeyListener
from java.awt.event import KeyEvent

class KeyListenerMain(KeyListener):
    def __init__(self,main_class):
        self.main_class = main_class

    def keyPressed(self,e):
        key_code = e.getKeyCode()
        key_char = e.getKeyChar()
        source = e.getSource()
        number_of_choices = self.main_class.number_of_choices
        if key_char in [str(x) for x in range(1,number_of_choices + 1)]:
            if self.main_class.correct_choice == int(key_char): 
                self.main_class.reveal_answer('Correct!')
            else:
                self.main_class.reveal_answer('Wrong!')
        elif key_code == KeyEvent.VK_ENTER:
            self.main_class.test()
        elif key_code == KeyEvent.VK_ESCAPE:
            self.main_class.reveal_answer('You could have guessed!')
        elif key_char == 'm':
            self.main_class.mark_mastered('Word has been marked mastered.')
        elif key_char == 'd':
            self.main_class.open_dictionary()
        else:
            pass
    
    def keyReleased(self,e):
        pass
    
    def keyTyped(self,e):
        pass
