#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from java.awt.event import KeyListener
from java.awt.event import KeyEvent

from javax.swing.text import Position

class KeyListenerDictionary(KeyListener):
    def __init__(self,main_class):
        self.main_class = main_class

    def keyPressed(self,e):
        key_code = e.getKeyCode()
        key_char = e.getKeyChar()
        source = e.getSource()
        if (key_code == KeyEvent.VK_ENTER) and source.equals(self.main_class.dframe.txt_search):
            text = self.main_class.dframe.txt_search.getText().lower()
            word_index = self.main_class.db.get_word_index(text)
            if word_index != -1:
                html = self.main_class.get_word_html(word_index)
                self.main_class.dframe.result_box.setText(html)
                self.main_class.dframe.result_box.setCaretPosition(0)
            else:
                self.main_class.dframe.result_box.setText("Word not found")
        elif (self.main_class.dframe and source.equals(self.main_class.dframe.txt_search)):
            text = self.main_class.dframe.txt_search.getText()
            index = self.main_class.dframe.list_box.getNextMatch(text,0,Position.Bias.Forward)
            if index != -1:
                self.main_class.dframe.list_box.setSelectedIndex(index)
                self.main_class.dframe.list_box.ensureIndexIsVisible(index)
        else:
            pass
    
    def keyReleased(self,e):
        pass
    
    def keyTyped(self,e):
        pass
