#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from java.awt.event import ComponentListener

class ComponentListenerDictionary(ComponentListener):
    def __init__(self,main_class):
        self.main_class = main_class

    def componentResized(self,e):
        new_size = e.getSource().getSize()
        self.main_class.configurator.set("dictionary_frame.width",new_size.width)
        self.main_class.configurator.set("dictionary_frame.height",new_size.height)

    def componentHidden(self,e):
        pass

    def componentMoved(self,e):
        pass

    def componentShown(self,e):
        pass
