#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from HTMLFrame import HTMLFrame
from java.awt import Toolkit

def build_gbc(gbc,x,y,width,height,weightx,weighty,fill):
    """utility function for setting constrains for grid bag layout
    """
    gbc.gridx = x
    gbc.gridy = y
    gbc.gridwidth = width
    gbc.gridheight = height
    gbc.weightx = weightx
    gbc.weighty = weighty
    gbc.fill = fill

def display_html(html,title,width,height):
    html_frame = HTMLFrame()
    html_frame.setSize(width,height)
    html_frame.setLocation(
        html_frame.getToolkit().getScreenSize().width/2 - html_frame.getWidth()/2,
        html_frame.getToolkit().getScreenSize().height/2 - html_frame.getHeight()/2
    )
    html_frame.setTitle(title)
    html_frame.setVisible(True)
    html_frame.update(html_frame.getGraphics())
    html_frame.set_html(html)
    return html_frame
