#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JWindow
from java.awt import Color
from java.awt import Toolkit

class Splasher(JWindow):
    def __init__(self,image_src):
        JWindow.__init__(self)
        
        self.splash_image = Toolkit.getDefaultToolkit().getImage(image_src)

        self.setSize(self.splash_image.getWidth(),self.splash_image.getHeight())
        self.setLocation(
            self.getToolkit().getScreenSize().width/2 - self.getWidth()/2,
            self.getToolkit().getScreenSize().height/2 - self.getHeight()/2
        )
        self.getContentPane().setOpaque(True)
        self.getContentPane().setBackground(Color.white)
        self.setVisible(True)
        self.getGraphics().drawImage(self.splash_image,0,0,None)
        
    def __del__(self):
        JWindow.__del__(self)

    def paint(self,g):
        JWindow.paint(self,g)
        g.drawImage(self.splash_image,0,0,None)

