#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JPanel
from javax.swing import JScrollPane
from java.awt import GridBagLayout
from java.awt import GridBagConstraints

from HTMLBox import HTMLBox

from utility import *

class PanelOutput(JPanel):
    def __init__(self):
        JPanel.__init__(self)
        self.__add_controls()

    def __del__(self):
        JPanel.__del__(self)
    
    def __add_controls(self):
        gbl = GridBagLayout()
        gbc = GridBagConstraints()
        self.setLayout(gbl)

        self.output_box = HTMLBox()
        scroll = JScrollPane(self.output_box)
        build_gbc(gbc,0,0,1,1,100,100,GridBagConstraints.BOTH)
        self.add(scroll,gbc)

