#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JPanel
from javax.swing import JLabel
from javax.swing import BorderFactory
from java.awt import GridBagLayout
from java.awt import GridBagConstraints
from java.awt import Insets

from utility import *

class PanelLabels(JPanel):
    def __init__(self):
        JPanel.__init__(self)
        self.__add_controls()
    
    def __del__(self):
        JPanel.__del__(self)

    def __add_controls(self):
        gbl = GridBagLayout()
        gbc = GridBagConstraints()
        self.setLayout(gbl)
       
        jp = JPanel()
        jp.setLayout(gbl)
        self.lbl_practice_set = JLabel("Current Practice Set : Normal",JLabel.LEFT)
        build_gbc(gbc,0,0,1,1,100,10,GridBagConstraints.BOTH)
        gbc.insets = Insets(2,2,2,2)
        jp.add(self.lbl_practice_set,gbc)

        self.lbl_words_mastered = JLabel("% mastered",JLabel.LEFT)
        build_gbc(gbc,0,1,1,1,100,10,GridBagConstraints.BOTH)
        gbc.insets = Insets(2,2,2,2)
        jp.add(self.lbl_words_mastered,gbc)

        jp.setBorder(BorderFactory.createTitledBorder(""));
        
        build_gbc(gbc,0,0,1,1,100,20,GridBagConstraints.BOTH)
        gbc.insets = Insets(0,0,0,0)
        self.add(jp,gbc)
       
        jp = JPanel()
        jp.setLayout(gbl)
        
        self.lbl_test_word = JLabel("Word", JLabel.LEFT)
        build_gbc(gbc,0,2,1,1,100,10,GridBagConstraints.BOTH)
        gbc.insets = Insets(2,2,2,2)
        jp.add(self.lbl_test_word,gbc)

        self.lbl_times_tested = JLabel("Number of times tesed : 0",JLabel.LEFT)
        build_gbc(gbc,0,3,1,1,100,10,GridBagConstraints.BOTH);
        gbc.insets = Insets(2,2,2,2)
        jp.add(self.lbl_times_tested,gbc);
                
        jp.setBorder(BorderFactory.createTitledBorder("Test Word"));
        build_gbc(gbc,0,1,1,1,100,20,GridBagConstraints.BOTH)
        gbc.insets = Insets(0,0,0,0)
        self.add(jp,gbc)
