#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JMenuBar
from javax.swing import JMenu
from javax.swing import JMenuItem
from javax.swing import ImageIcon
from javax.swing import ButtonGroup
from javax.swing import JRadioButtonMenuItem

from java.awt import Toolkit

class MenuBar(JMenuBar):
    def __init__(self,index_names,active_index_name):
       JMenuBar.__init__(self)
       self.index_names = index_names
       self.menu_items = []
       self.__build_menus(active_index_name)

    def __del__(self):
        JMenuBar.__del__(self)
    
    def __build_menus(self,active_index_name):
        self.__build_file_menu(active_index_name)
        self.__build_tools_menu()
        self.__build_games_menu()
        self.__build_help_menu()

    def add_practice_set(self,name):
        if name not in self.index_names:
            self.index_names.append(name)
            radio_item = JRadioButtonMenuItem(name)
            self.file_menu_practice_sets.add(radio_item)
            self.practice_sets_group.add(radio_item)
            self.menu_items.append(radio_item)
            return radio_item

    def __build_file_menu(self,active_index_name):
       file_menu = JMenu("File")
      
       icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/practice_sets.png"))
       self.file_menu_practice_sets = JMenu("Practice Sets")
       self.file_menu_practice_sets.setIcon(icon)
       self.practice_sets_group = ButtonGroup()
       for x in self.index_names:
           radio_item = JRadioButtonMenuItem(x,x == active_index_name)
           self.file_menu_practice_sets.add(radio_item)
           self.practice_sets_group.add(radio_item)
           self.menu_items.append(radio_item)
       file_menu.add(self.file_menu_practice_sets)
      
       file_menu.addSeparator()
       icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/reset.png"))
       file_menu_reset = JMenu("Reset Database")
       file_menu_reset.setIcon(icon)
       
       icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/reset.png"))
       
       self.file_menu_reset_number_of_times_tested = JMenuItem("Reset Number of Times Tested",icon)
       file_menu_reset.add(self.file_menu_reset_number_of_times_tested)
       self.menu_items.append(self.file_menu_reset_number_of_times_tested)
       
       self.file_menu_reset_mastered_words = JMenuItem("Reset Mastered Words",icon)
       file_menu_reset.add(self.file_menu_reset_mastered_words)
       self.menu_items.append(self.file_menu_reset_mastered_words)

       file_menu.add(file_menu_reset)

       file_menu.addSeparator()
       
       icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/exit.png"))
       self.file_menu_exit = JMenuItem("Save and Exit (Default)",icon)
       file_menu.add(self.file_menu_exit)
       self.menu_items.append(self.file_menu_exit)
       
       icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/exit.png"))
       self.file_menu_exit_without_save = JMenuItem("Exit without Saving",icon)
       file_menu.add(self.file_menu_exit_without_save)
       self.menu_items.append(self.file_menu_exit_without_save)

       self.add(file_menu)

    def __build_tools_menu(self):
        tools_menu = JMenu("Tools")
         
        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/stats.png"))
        self.tools_menu_view_statistics = JMenuItem("View Statistics",icon)
        tools_menu.add(self.tools_menu_view_statistics)
        self.menu_items.append(self.tools_menu_view_statistics)

        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/dictionary.png"))
        self.tools_menu_dictionary = JMenuItem("Dictionary",icon)
        tools_menu.add(self.tools_menu_dictionary)
        self.menu_items.append(self.tools_menu_dictionary)
        
        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/pronunciation_guide.png"))
        self.tools_menu_pronunciation_guide = JMenuItem("Pronunciation Guide",icon)
        tools_menu.add(self.tools_menu_pronunciation_guide)
        self.menu_items.append(self.tools_menu_pronunciation_guide)
        
        self.add(tools_menu)

    def __build_games_menu(self):
        games_menu = JMenu("Games")
        
        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/hangman.png"))
        self.games_menu_hangman = JMenuItem("Hangman",icon)
        games_menu.add(self.games_menu_hangman)
        self.menu_items.append(self.games_menu_hangman)
        
        self.add(games_menu)

    def __build_help_menu(self):
        help_menu = JMenu("Help")

        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/help.png"))
        self.help_menu_help = JMenuItem("Help",icon)
        help_menu.add(self.help_menu_help)
        self.menu_items.append(self.help_menu_help)

        icon = ImageIcon(Toolkit.getDefaultToolkit().getImage("files/icons/info.png"))
        self.help_menu_about = JMenuItem("About",icon)
        help_menu.add(self.help_menu_about)
        self.menu_items.append(self.help_menu_about)

        self.add(help_menu)
    
    def disable_practice_sets(self,index_names_to_disable):
        for x in self.menu_items:
            if x.getText() in index_names_to_disable:
                x.setEnabled(False)
            else:
                x.setEnabled(True)

