#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JFrame
from javax.swing import JScrollPane
from javax.swing import UIManager
from java.awt import GridBagLayout
from java.awt import GridBagConstraints
from java.awt import Insets
from java.awt import Dimension
from java.awt import Toolkit

from MenuBar import MenuBar
from PanelOutput import PanelOutput
from PanelChoices import PanelChoices
from PanelLabels import PanelLabels

from utility import *

class MainFrame(JFrame):
    def __init__(self,index_names,active_index_name):
        JFrame.__init__(self,"words")
        self.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
        self.init_controls(index_names,active_index_name)

    def __del__(self):
        JFrame.__del__(self)

    def init_controls(self,index_names,active_index_name):
        self.menu_bar = MenuBar(index_names,active_index_name)
        self.setJMenuBar(self.menu_bar)

        gbl = GridBagLayout()
        gbc = GridBagConstraints()
        self.setLayout(gbl)

        build_gbc(gbc,0,0,1,1,100,20,GridBagConstraints.BOTH)
        gbc.insets = Insets(5,5,5,5)
        self.panel_labels = PanelLabels()
        self.getContentPane().add(self.panel_labels,gbc)

        build_gbc(gbc,0,1,1,1,100,40,GridBagConstraints.BOTH)
        gbc.insets = Insets(0,0,0,0)
        self.panel_choices = PanelChoices()
        self.panel_choices.setPreferredSize(Dimension(300,100))
        self.getContentPane().add(self.panel_choices,gbc)
                
        build_gbc(gbc,0,2,1,1,100,60,GridBagConstraints.BOTH)
        gbc.insets = Insets(0,0,0,0)
        self.panel_output = PanelOutput()
        self.getContentPane().add(self.panel_output,gbc)
        
        icon = Toolkit.getDefaultToolkit().getImage("files/icons/icon.png")
        self.setIconImage(icon)

