#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JScrollPane
from javax.swing import JFrame
from java.awt import Toolkit

from HTMLBox import HTMLBox

class HTMLFrame(JFrame):
    def __init__(self):
        JFrame.__init__(self)
        self.__add_controls()

    def __del__(self):
        JFrame.__del__(self)
    
    def __add_controls(self):
        self.html_pane = HTMLBox()
        scroll = JScrollPane(self.html_pane)
        self.getContentPane().add(scroll)
        self.html_pane.update(self.html_pane.getGraphics())
        
        icon = Toolkit.getDefaultToolkit().getImage("files/icons/icon.png")
        self.setIconImage(icon)

    def set_html(self,html):
        self.html_pane.setText(html)
        self.html_pane.setCaretPosition(0)
        self.html_pane.update(self.html_pane.getGraphics())

