#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

from javax.swing import JFrame
from javax.swing import JTextField
from javax.swing import JButton
from javax.swing import JScrollPane
from javax.swing import JList
from java.awt import Toolkit

from java.awt import GridBagLayout
from java.awt import GridBagConstraints
from java.awt import Insets

from HTMLBox import HTMLBox
from utility import *

class DictionaryFrame(JFrame):
    def __init__(self):
        JFrame.__init__(self)
        self.__add_controls()

    def __del__(self):
        JFrame.__del__(self)

    def __add_controls(self):
        gbl = GridBagLayout()
        gbc = GridBagConstraints()
        self.setLayout(gbl)

        self.txt_search = JTextField("")
        build_gbc(gbc,0,0,1,1,80,5,GridBagConstraints.HORIZONTAL)
        gbc.insets = Insets(5,5,5,5)
        self.getContentPane().add(self.txt_search,gbc)

        self.cmd_search = JButton("Search")
        build_gbc(gbc,1,0,1,1,20,5,GridBagConstraints.NONE)
        gbc.anchor = GridBagConstraints.WEST
        gbc.insets = Insets(5,5,5,5)
        self.getContentPane().add(self.cmd_search,gbc)

        self.result_box = HTMLBox()
        build_gbc(gbc,0,1,1,1,95,40,GridBagConstraints.BOTH)
        gbc.insets = Insets(5,5,5,5)
        scroll = JScrollPane(
            self.result_box,
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
            JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
        )
        self.getContentPane().add(scroll,gbc)

        self.list_box = JList()
        build_gbc(gbc,1,1,1,1,5,40,GridBagConstraints.BOTH)
        gbc.insets = Insets(5,5,5,5)
        scroll = JScrollPane(
            self.list_box,
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
            JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
        )
        self.getContentPane().add(scroll,gbc)
        
        icon_image = Toolkit.getDefaultToolkit().getImage("files/icons/dictionary.png")
        self.setIconImage(icon_image)
