#!/usr/bin/python

#
# Copyright 2008 Amit Shrestha
#

'''
This file is part of Words.

Words is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Words is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Words.  If not, see <http://www.gnu.org/licenses/>.
'''

class Configurator:
    """stores configuration info and implements utility functions
    """

    def __init__(self):
        self.configurations = {}

    def read_configurations(self, config_path):
        self.config_path = config_path
        config = open(config_path,'r')

        ln = 0
        for line in config:
            ln += 1
            if not line.strip() or line.startswith('#'): continue
            splits = [x.strip() for x in line.split('::')]
            if len(splits) != 2:
                print "Error in line %d in file %s" % (ln,config_path)
                config.close()
                sys.exit(1)
            self.configurations[splits[0].lower()] = splits[1]
        config.close()

    def save_configurations(self, save_path):
        if not self.configurations: return

        config = open(save_path,'w')
        for k,v in self.configurations.iteritems():
            config.write("%s::%s\n" % (k,v))
        config.close()

    def set(self,key,value):
        self.configurations[str(key)] = str(value)

    def get_string(self,key):
        if self.configurations.has_key(str(key)):
            return self.configurations[str(key)]
        else: return None

    def get_int(self,key):
        try:
            return int(self.configurations[str(key)])
        except:
            return None
    
    def get_float(self,key):
        try:
            return float(self.configurations[str(key)])
        except:
            return None
